<?php

namespace App\AppEvents;

use Illuminate\Database\Eloquent\Model;

class Venue extends Model 
{

    protected $table = 'venues';
    public $timestamps = true;
    protected $fillable = array('name', 'address_line_one', 'address_line_two', 'city', 'province', 'country', 'area_code');

    public function events()
    {
        return $this->belongsToMany('App\AppEvents\Event');
    }

    public function tickets()
    {
        return $this->hasMany('App\AppEvents\Ticket');
    }

    public function pricing()
    {
        return $this->hasOne('App\AppEvents\Pricing');
    }

    public function dates()
    {
        return $this->hasMany('App\AppEvents\Date');
    }

}